<?php

function uwd_create_post_type() {

    register_post_type('uwd_sliders',
        array(
            'labels' => array(
                'name' => __('Sliders', 'uwd'),
                'singular_name' => __('Slider', 'uwd')
            ),
            'public' => true,
            //'has_archive' => true,
            //'hierarchical' => true,
            //'exclude_from_search' => true,
            //'rewrite' => array('slug' => 'uwd_sliders' ),
            'menu_icon'   => 'dashicons-media-interactive',
            'taxonomies' => array('post_tag'),
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt',  ) //
        )
    );


}

add_action('init', 'uwd_create_post_type');







//////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

add_action( 'add_meta_boxes', 'uwd_box_add' );
function uwd_box_add() {
    add_meta_box( 'uwd_metabox_post', __('Metabox','uwd'), 'uwd_meta_box_post', 'uwd_sliders', 'normal', 'high' );
}

function uwd_meta_box_post()
{

    // $post is already set, and contains an object: the WordPress post
    global $post;
    $uwd_values = get_post_custom( $post->ID );
     

    //main settings
    $uwd_slider_bg_word = get_post_meta( get_the_ID(), 'uwd_slider_bg_word', true );
    $uwd_slider_label = get_post_meta( get_the_ID(), 'uwd_slider_label', true );
    

    
    ?>



    <div id="uwd_id_metabox_cpt">
        <div class="uwd_id_metabox_cpt_content">
            
            <div>
                  <p><strong><?php _e('Slider Label','uwd'); ?></strong></p>
                  <p><input class="uwd_width_100_percentage" type="text" name="uwd_slider_label" id="uwd_slider_label" value="<?php echo $uwd_slider_label ?>" /></p>
            </div>

            <div>
                  <p><strong><?php _e('Slider Background Word','uwd'); ?></strong></p>
                  <p><input class="uwd_width_100_percentage" type="text" name="uwd_slider_bg_word" id="uwd_slider_bg_word" value="<?php echo $uwd_slider_bg_word ?>" /></p>
            </div>
        </div>
    </div>



    <?php   

}


add_action( 'save_post', 'uwd_meta_box_save' );
function uwd_meta_box_save( $post_id )
{

    //main settings : sanitize and validate


    $uwd_slider_bg_word = sanitize_meta('uwd_slider_bg_word',$_POST['uwd_slider_bg_word'],'post');
    if ( isset( $uwd_slider_bg_word ) ) { 

      if ( $uwd_slider_bg_word != '' ) {
        update_post_meta( $post_id, 'uwd_slider_bg_word' , $uwd_slider_bg_word );
      }else{
        delete_post_meta( $post_id,'uwd_slider_bg_word');
      }
       
    }

    $uwd_slider_label = sanitize_meta('uwd_slider_label',$_POST['uwd_slider_label'],'post');
    if ( isset( $uwd_slider_label ) ) { 

      if ( $uwd_slider_label != '' ) {
        update_post_meta( $post_id, 'uwd_slider_label' , $uwd_slider_label );
      }else{
        delete_post_meta( $post_id,'uwd_slider_label');
      }
       
    }

}
