<?php
/*
Plugin Name: UWD - Helper Plugin
Plugin URI: http://urgentwebdes.com
Description: A custom site functions plugin for UWD projects
Version: 1.0
Author: UWD Programmers
*/
/*Theme Functions - Hand Written in order to design & develop the theme */

require_once( dirname( __FILE__ ) . '/includes/custom-post-types.php' );



function uwd_breadcrumbs() {

    // Code
    if(!is_home()) {
        echo '<nav class="breadcrumb">';
        echo '<a href="'.home_url('/').'">'.get_bloginfo('name').'</a><span class="breadcrumbs-divider"> &rarr; </span>';
        if (is_category() || is_single()) {
            the_category(' <span class="breadcrumbs-divider"> &rarr; </span> ');
            if (is_single()) {
                echo ' <span class="breadcrumbs-divider"> &rarr; </span> ';
                the_title();
            }
        } elseif (is_page()) {
            echo the_title();
        }
        echo '</nav>';
    }
}
add_shortcode( 'uwd_breadcrumbs', 'uwd_breadcrumbs' );





/**==============================================================================
 * UWD Add Thumbnail to Admin Posts / Pages
 *================================================================================*/


add_image_size( 'uwd-admin-post-featured-image', 120, 120, false );
 
// Add the posts and pages columns filter. They can both use the same function.
add_filter('manage_posts_columns', 'uwd_add_post_admin_thumbnail_column', 2);
add_filter('manage_pages_columns', 'uwd_add_post_admin_thumbnail_column', 2);
 
// Add the column
function uwd_add_post_admin_thumbnail_column($uwd_columns){
    $uwd_columns['uwd_thumb'] = __('Thumbnail', 'urgent-web-design');
    return $uwd_columns;
}
 
// Let's manage Post and Page Admin Panel Columns
add_action('manage_posts_custom_column', 'uwd_show_post_thumbnail_column', 5, 2);
add_action('manage_pages_custom_column', 'uwd_show_post_thumbnail_column', 5, 2);
 
// Here we are grabbing featured-thumbnail size post thumbnail and displaying it
function uwd_show_post_thumbnail_column($uwd_columns, $uwd_id){
    switch($uwd_columns){
        case 'uwd_thumb':
        if( function_exists('the_post_thumbnail') )
            echo the_post_thumbnail( 'uwd-admin-post-featured-image' );
        else
            echo 'Your theme doesn\'t support featured image...';
        break;
    }
}
