<?php

class Custom_WC_Product_Categories_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'custom_wc_product_categories_widget',
            __('Custom WC Product Categories', 'text_domain'),
            array('description' => __('A custom widget for WooCommerce product categories.', 'text_domain'))
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];

        // Display product categories
        echo '<ul class="product-categories custom-menu">';
        wp_list_categories(array(
            'taxonomy'   => 'product_cat',
            'title_li'   => '',
            'hide_empty' => 1,
            'walker'     => new Custom_WC_Category_Walker(),
        ));
        echo '</ul>';

        echo $args['after_widget'];
    }
}

class Custom_WC_Category_Walker extends Walker_Category {
    public function start_el(&$output, $category, $depth = 0, $args = array(), $current_object_id = 0) {
        if (!$category || !is_object($category)) {
            return;
        }

        $output .= "<li class='cat-item cat-item-{$category->term_id}";

        // Check for current category
        if (isset($category->classes) && is_array($category->classes) && in_array('current-cat', $category->classes)) {
            $output .= ' current-cat';
        }

        // Check for parent category
        if (isset($args->has_children) && $args->has_children) {
            $output .= ' parent';
        }

        $output .= "'>";
        parent::start_el($output, $category, $depth, $args, $current_object_id);
    }
}

function register_custom_wc_product_categories_widget() {
    register_widget('Custom_WC_Product_Categories_Widget');
}

add_action('widgets_init', 'register_custom_wc_product_categories_widget');

function custom_register_sidebar() {
    register_sidebar(
        array(
            'name'          => esc_html__('WooCommerce Sidebar', 'your-theme-textdomain'),
            'id'            => 'woocommerce-sidebar',
            'description'   => esc_html__('Widgets for the WooCommerce shop page.', 'your-theme-textdomain'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );
}

add_action('widgets_init', 'custom_register_sidebar');






function custom_wc_products_per_page($cols) {
    return 6;
}

add_filter('loop_shop_per_page', 'custom_wc_products_per_page', 20);
