<?php
defined('ABSPATH') || exit;
get_header('shop');
?>

<?php do_action('woocommerce_before_main_content');?>

<header class="woocommerce-products-header">
    <?php if (apply_filters('woocommerce_show_page_title', true)): ?>
        <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title();?></h1>
    <?php endif;?>
    <?php do_action('woocommerce_archive_description');?>
</header>

<style>
    /* Adjust styles for the WooCommerce Sidebar */
#woocommerce-sidebar {
    background-color: #f4f4f4;
    padding: 20px;
    border-radius: 5px;
    position: relative;
    z-index: 1;
}

/* Simplified styles for better readability */
.widget-title {
    font-size: 16px;
    margin-bottom: 15px;
}

.widget {
    margin-bottom: 20px;
}

.container {
    display: flex;
    flex-wrap: wrap; /* Added flex-wrap for responsiveness */
}

.sidebar {
    width: 100%; /* Full width on small screens */
    padding: 20px;
    box-sizing: border-box;
}

.main-content {
    width: 100%; /* Full width on small screens */
    padding: 20px;
    box-sizing: border-box;
}

/* Style for the main menu */
ul.product-categories {
    list-style: none;
    padding: 0;
}

ul.product-categories li {
    display: block;
    position: relative;
}

ul.product-categories a {
    text-decoration: none;
    color: #333;
    padding: 10px 20px;
    display: block;
}

/* Style for the sub-menu (children) */
ul.product-categories ul.children {
    list-style: none;
    padding: 0;
    min-width: 250px;
    display: none;
    position: absolute;
    background-color: #fff;
    border: 1px solid #ddd;
    z-index: 9999;
    left: 0; /* Position child menu from the left edge */
}

ul.product-categories ul.children li {
    display: block;
    position: relative;
}

/* Add bottom border */
ul.product-categories ul.children li a {
    padding: 10px 20px;
    position: relative;
}

/* Add right arrow for items with children */
ul.product-categories ul.children li:has(ul.children) > a:after {
    content: '\2192'; /* Unicode right arrow character */
    position: absolute;
    right: 10px;
}

ul.product-categories ul.children li:last-child a {
    border-bottom: 1px solid #ddd;
}

/* Highlight the current parent menu item */
ul.product-categories .current-cat-parent > a,
ul.product-categories .current-cat-ancestor > a,
ul.product-categories .current-cat > a {
    background-color: orange; /* Change to your desired color */
    color: #333; /* Change to your desired text color */
}

/* Show sub-menu when parent is hovered */
ul.product-categories li:hover > ul.children {
    display: block;
}

/* Add right arrow only where there is a children element */
ul.product-categories li:has(ul.children) > a:after {
    content: '\2193'; /* Unicode down arrow character */
    position: absolute;
    right: 10px;
}

@media (min-width: 768px) {
    .sidebar {
        width: 25%; /* Sidebar takes 25% width on larger screens */
    }

    .main-content {
        width: 75%; /* Main content takes 75% width on larger screens */
    }

    /* Adjust child menu position for smaller screens */
    ul.product-categories ul.children {
        /* left: 100%; Position child menu from the right edge */
    }

    ul.product-categories ul.children {
        left: 100%; /* Reset position to align with parent menu */
        top: 0; /* Reset position to align with parent menu */
        margin-top: -1px; /* Adjust for border thickness */
    }

    /* Adjust arrow position for smaller screens */
    ul.product-categories li:has(ul.children) > a:after {
        content: '\2192'; /* Unicode right arrow character */
        position: absolute;
        left: auto; /* Reset left position */
        right: 10px; /* Position arrow on the right side with proper spacing */
        top: 50%; /* Position arrow vertically centered */
        transform: translateY(-50%); /* Adjust vertical alignment */
    }
}


</style>

<div class="products-archive container">
    <div class="sidebar">
        <div id="woocommerce-sidebar">
            <?php dynamic_sidebar('woocommerce-sidebar');?>
        </div>
    </div>

    <div class="main-content">
        <div id="woocommerce-content">
            <?php
            if (woocommerce_product_loop()) {
                woocommerce_product_loop_start();
                if (wc_get_loop_prop('total')) {
                    while (have_posts()) {
                        the_post();
                        wc_get_template_part('content', 'product');
                    }
                }
                woocommerce_product_loop_end();
                do_action('woocommerce_after_shop_loop');
            } else {
                do_action('woocommerce_no_products_found');
            }
            ?>
        </div>
    </div>
</div>

<?php
do_action('woocommerce_after_main_content');
do_action('woocommerce_sidebar');
get_footer('shop');
?>
